<?php defined('PF_VERSION') OR exit('Access denied'); ?>
<?php

define('PLUGIN_TECHTIMONIALS', __('Testimonials'));

class Testimonials_Plugin extends Pf_Plugin{
    public $name = PLUGIN_TECHTIMONIALS;
    public $version = '1.0';
    public $author = 'PageFlex Team';
    public $description = 'This is Testimonials description';
    
    public function activate(){
    	$db = Pf::database();
    
    	$sql = "DROP TABLE IF EXISTS `pf_testimonials`;";
    	$db->query($sql);
    
    	$sql = "CREATE TABLE `pf_testimonials` (
                    `testimonial_id` int(11) NOT NULL AUTO_INCREMENT,
                    `testimonial_name` varchar(50) NOT NULL,
                    `testimonial_content` varchar(1000) NOT NULL,
                    `testimonial_info` varchar(200) NOT NULL,
                    `testimonial_status` int(11) NOT NULL,
                    `testimonial_avatar` varchar(200) NOT NULL,
                    PRIMARY KEY (`testimonial_id`)
                   ) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8
                ";
    
    	$db->query($sql);
    }
    
    public function deactivate(){
    	$db = Pf::database();
    	$sql = "DROP TABLE IF EXISTS `pf_testimonials`;";
    
    	$db->query($sql);
    }

    public function admin_init(){
        if (is_admin() or is_editor() or is_author())
            $this->admin_menu('fa fa-thumbs-o-up', __('Testimonials', 'testimonials'), 'testimonials', 'testimonials_manager' );
    }
    public function public_init(){
        $shortcode = Pf::shortcode();
        $shortcode->add( 'testimonials', array($this,'testimonials_list_category' ));
    }
    
    function testimonials_list_category( $atts, $content = null, $code = '' ){
       $testid  =   !empty($atts['id'])?$atts['id']:'';
       require_once abs_plugin_path(__FILE__) . "/testimonials/class/testimonials-class.php";
        $public =   new Pf_Testimonials();
        ob_start();
        require abs_plugin_path(__FILE__) . "/testimonials/public/testimonial-public.php";
        $content = ob_get_contents();
        ob_end_clean();
        return $content;
    }

    public function testimonials_manager(){
        if (is_admin() or is_editor() or is_author()) {
            $ref = array('admin-page' => 'testimonials');
            if (!empty($_GET['page']))
                $ref['page'] = $_GET['page'];
            if (!empty($_GET['testimonialname']))
                $ref['testimonialname'] = $_GET['testimonialname'];
            if (!empty($_GET['publish'])) $ref['publish']    =   $_GET['publish'];
        $this->js('admin/plugins/media/assets/fancybox/jquery.fancybox-1.3.6.pack.js');
        $this->css('admin/plugins/media/assets/fancybox/jquery.fancybox-1.3.6.css');  
        $this->css('admin/themes/default/assets/bootstrap-modal/css/animate.min.css');
        $this->js('admin/themes/default/assets/bootstrap-modal/js/bootstrap.modal.js');
        $this->css('testimonials/assets/testimonials.css',__FILE__);
        $this->js('testimonials/assets/testimonials.js',__FILE__);
        $this->js ( 'admin/themes/default/assets/bootstrap-notification/js/bootstrap.notification.js' );
        require abs_plugin_path(__FILE__) . '/testimonials/assets/testimonials-common.php';
        require abs_plugin_path(__FILE__) . '/testimonials/class/testimonials-class.php';
        require abs_plugin_path(__FILE__) . '/testimonials/actions/'.$action.'.php';
    } else
            echo __('Access Denied!','testimonials');
    }
}